const fs = require('fs');
const path = require('path');

console.log('🔄 Resetando sessão do WhatsApp...\n');

const tokensPath = path.join(__dirname, '..', 'tokens');

try {
  // Verifica se a pasta tokens existe
  if (fs.existsSync(tokensPath)) {
    // Remove todos os arquivos da pasta tokens
    fs.rmSync(tokensPath, { recursive: true, force: true });
    console.log('✅ Sessão antiga removida');
  } else {
    console.log('⚠️  Pasta tokens não existe');
  }

  // Recria a pasta tokens
  fs.mkdirSync(tokensPath, { recursive: true });
  console.log('✅ Nova pasta tokens criada');

  console.log('\n💡 Agora execute: npm start');
  console.log('   Para fazer uma nova autenticação\n');

} catch (error) {
  console.error('❌ Erro ao resetar sessão:', error.message);
  process.exit(1);
}
